package editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;

import game.CustomImageDataII;
import game.IntRect;

public class BlueEnemyScreenPaletteObject extends ScreenPaletteObject {

	public BlueEnemyScreenPaletteObject(IntRect theClickRect, int theDistanceToBorder, int theBorderWidth, ImageObserver io) {
		
		clickRect = theClickRect;
		
		image = new CustomImageDataII("/images/elemental_icon_blue.GIF", Color.white, io);
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		
	}
	
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		
		return new BlueEnemyScreenObject(objX, objY, io);
	}

	@Override
	public void draw(Graphics g) {
		
		if(clickRect == null)
			return;
		
		Point p = clickRect.getCenter();
		
		image.drawObjectIgnoreBounds(g, p.x, p.y);
		
		Color origCol = g.getColor();
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
		
	}


	@Override
	public void delete(ScreenObject so) {
		// TODO Auto-generated method stub
		
	}

}
